# Automatisierte Generierung des Praktikums-Ordners

Aus dem Praktikums-Ordner, mit seinen Referenzimplementierungen der Praktika, kann mittels
[ak-strip.sh](../../ak-strip.sh) ein Skelett-Praktikums-Ordner erstellt werden. Das Skript
erwartet beim Aufruf den Pfad des Referenz-Ordners und geht dann wie folgt vor:

1. Als erstes wird der Ordner Kopiert.
2. Danach werden alle .cpp Dateien nach Blöcken, markeirt durch `// AK_STRIP_START`
`// AK_STRIP_END`, durchsucht, die entfernt werden.
3. Schlussendlich wird über allen Testdateien eine Checksumme erstellt, die in separaten
Datein im Unterordner `checksums` gespeichert werden. Zum Beispiel wird für die
Testdatei `des-test.cpp` die Datei `checksums/des-test.cpp.sum` erstellt.

## ak-strip

Das Kommandozeilentool hat mehrere Optionen. Um einfach nur einen Praktikumsordner
zu erstellen kann das Tool mit `ak-strip.sh <AK-Ref-Impl>` aufgerufen werden.

* `h` - Zeigt den Hilfstext an.
* `c` - Berechnet die Prüfsummen aller gefundenen Testdateien innnerhalb des
angegebenen Ordners.
* `p <Praktikum>` - Extrahiere nur das angegebene Praktikum.

### Beispiele

Kopieren aller Praktika

```
$ ./AngewKrypt/ak-strip.sh AngewKrypt/
check if directory `ak-stripped` exists...
`ak-stripped` found: remove directory
copy project folder `AngewKrypt/` into `ak-stripped`
strip code blocks...
ak-stripped/src/ASIO-Demo/asioclient.cpp
ak-stripped/src/ASIO-Demo/asioserver.cpp
...
ak-stripped/src/Praktikum-1/ClassicCipher.cpp
generate checksums for test folder...
e5f35ea0ad4033abc409e69ae6f583f90a3da80448c2d9076fa624f022f9b5db  ./src/Praktikum-DES/tests/des-test.cpp
c2540450178a28f56788343a2d8c2d9e1fc8c690214c081751fc983a3f860956  ./src/Praktikum-CryptoPP/tests/cryptopp-test.cpp
906975df463440fc1dc6f5c9727cce08beaa59cb8608d75b14ff05ece06a3b1f  ./src/Praktikum-AES/tests/aes-test.cpp
600e675e3c6d41af8ac7fc5128780a8ba187e95f4c514c838f6483a1d698e1cb  ./src/Praktikum-DH-Protokoll/tests/dh-test.cpp
e917dd42a023d84c1d0227d0acc76b9c78d1f6b912533a05a7ffc7fda697a473  ./src/Praktikum-Vigenere/tests/vigenere-test.cpp
ddb0f7727457d2c77ea4d2c8682977fe6ccf2a2619bd0c448ea66992eb8eb9fe  ./src/Praktikum-Primzahlen/tests/primzahlen-test.cpp
bafa5dc5a7b05c73e50b40c11e3f8dd554b091619d29edda082939d176205f33  ./src/Praktikum-Public-Key/tests/pubkey-test.cpp
checksums written to ./checksums
```

Kopieren eines spezifischen Praktikums

```
$ ./AngewKrypt/ak-strip.sh -p Praktikum-DES AngewKrypt/
check if directory `ak-stripped` exists...
`ak-stripped` found: remove directory
copy project folder `AngewKrypt/` into `ak-stripped`
strip code blocks...
ak-stripped/src/Praktikum-DES/desTest.cpp
ak-stripped/src/Praktikum-DES/des-main.cpp
ak-stripped/src/Praktikum-DES/BlockCipher.cpp
ak-stripped/src/Praktikum-DES/DESCipher.cpp
generate checksums for test folder...
e5f35ea0ad4033abc409e69ae6f583f90a3da80448c2d9076fa624f022f9b5db  ./src/Praktikum-DES/tests/des-test.cpp
checksums written to ./checksums
```

Berechnung aller Prüfsummen

```
$ ./AngewKrypt/ak-strip.sh -c AngewKrypt/
e5f35ea0ad4033abc409e69ae6f583f90a3da80448c2d9076fa624f022f9b5db  AngewKrypt/src/Praktikum-DES/tests/des-test.cpp
c2540450178a28f56788343a2d8c2d9e1fc8c690214c081751fc983a3f860956  AngewKrypt/src/Praktikum-CryptoPP/tests/cryptopp-test.cpp
906975df463440fc1dc6f5c9727cce08beaa59cb8608d75b14ff05ece06a3b1f  AngewKrypt/src/Praktikum-AES/tests/aes-test.cpp
600e675e3c6d41af8ac7fc5128780a8ba187e95f4c514c838f6483a1d698e1cb  AngewKrypt/src/Praktikum-DH-Protokoll/tests/dh-test.cpp
e917dd42a023d84c1d0227d0acc76b9c78d1f6b912533a05a7ffc7fda697a473  AngewKrypt/src/Praktikum-Vigenere/tests/vigenere-test.cpp
ddb0f7727457d2c77ea4d2c8682977fe6ccf2a2619bd0c448ea66992eb8eb9fe  AngewKrypt/src/Praktikum-Primzahlen/tests/primzahlen-test.cpp
bafa5dc5a7b05c73e50b40c11e3f8dd554b091619d29edda082939d176205f33  AngewKrypt/src/Praktikum-Public-Key/tests/pubkey-test.cpp
checksums written to AngewKrypt//checksums
```

## DH-Praktikum

Da das DH-Praktikum relativ aufwendig zu testen ist, wurden zwei Skripte geschrieben
(`dh-alice-bob.sh` und `dh-alice-bob-oscar.sh`), die beim Ausführen der 
`Dockerfile` in `/user/local/bin` kopiert werden.

Um die Skripte auszuführen ist wie folgt vorzugehen:

1. Verbindung zur _Crypto Review Unit_ herstellen (normalerweise mit `docker-run`).
2. Mit dem Befehl `tmux` eine tmux-shell öffnen.
3. `dh-alice-bob` bzw. `dh-alice-bob-oscar` eingeben, um die jeweilige Aufgabe automatisiert auszuführen.

> Es werden zwei bzw. drei Fenster geöffnet und der Inhalt der Kommunikation angezeigt.
