#! /bin/bash
#
# ====================================================================
#
# Quick 'n' dirty script to check the projects of the lecture on
# applied cryptography
#
# ====================================================================

if [ -z "$1" ]; then
    echo "Usage: $0 <archive>"
    echo "archive must be a gzipped tar archive file."
    exit 1
fi

if [ -f $1 ]; then
    CHECK=$(file -z $1 | egrep "tar archive.*gzip compressed")
else 
	echo "ERROR: file $1 not found."
	exit 1
fi

echo ${CHECK}

if [ -z "${CHECK}" ]; then
    echo "FAIL!!! $1 is not a gzipped compressed tar archive"
    exit 1
fi

#
# Extract the archive
#
echo "Extracting archive $1."
tar xzf $1

#read -p "Press enter to continue"

#
# Wurzelverzeichnis aus dem TGZ-Archiv auslesen
#
DIR=`tar tf $1 | head -n 1`
DIR=$(echo "${DIR}" | cut -d "/" -f1)
echo -n "Checking base directory ${DIR}: "

if [ -d "${DIR}" ]; then
    echo "ok."
else
    echo "FAIL!!! ${DIR} is not a directory. "
    exit 1
fi


if [ -d "${DIR}/Debug" ]; then
    echo "FAIL!!! ${DIR}/Debug cannot be created."
    exit 1
fi

#
# Create CMake configuration and compile the sources.
#
#cp cmake-debug.sh $DIR/
cd $DIR
mkdir Debug
cd Debug
#../cmake-debug.sh
cmake-debug.sh && make

if [ $? -ne 0 ]; then
    echo "FAIL!!! Project did not build!"
    exit 1
fi

#
# The compiled binaries must be in the folder Debug/bin!
#
if [ ! -d "bin" ]; then
    echo "FAIL!!! Folder ${DIR}/bin not found!"
    exit 1
else
    export PATH=`pwd`/bin:${PATH}
fi

reset
echo

figlet "ITS CRYPTO REVIEW UNIT V4"

echo
echo "*************************"
echo "* Enter CTRL-D to quit. *"
echo "*************************"
echo

cd ..
echo "Project binaries:"
echo "================="
echo

ls Debug/bin
echo
echo "You are here: $(pwd)"
echo 

export PS1="> "

/bin/bash

#
# Remove project folder
#

read -p "Delete ${DIR}? [yN]" -n 1 -r
echo    # (optional) move to a new line
if [[ ! $REPLY =~ ^[Yy]$ ]]
then
    exit 1
else
    cd ..
    rm -r ${DIR}/
fi

echo 
figlet "Live long and prosper!"
 
