/*
 * Toolbox.h
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#ifndef TOOLBOX_H_
#define TOOLBOX_H_

#include <string>
#include <vector>
#include "Defs/types.h"

using namespace std;

class Toolbox {
public:
	Toolbox();
	virtual ~Toolbox();

	static string toHexString(const vector<byte>& ba, int block_len=-1);

	static string toString(const vector<bool>& bv, int block_len=-1);

	static string toString(const vector<ushort>& pv, int width=1);

	static string toString(const vector<byte>& ba);

	static vector<bool> decode(const vector<ushort>& word_vec, ushort word_len);

	static vector<ushort> encode(const vector<bool>& bit_vec, ushort word_len);

	static vector<bool> XOR(const vector<bool>& x, const vector<bool>& y);

	static vector<byte> toByteArray(const vector<bool>& bv);

	static vector<byte> toByteArray(const string& s);

	static vector<bool> toBitVector(const vector<byte>& ba);

	static vector<bool> toBitVector(string s);

	static vector<bool> toBitVector(const ushort& u, ushort len=16);

	static vector<bool> toBitVector(const uint& u, ushort len=32);

	static bool next(vector<bool>& v);

};

bool operator<(const vector<bool>& x, vector<bool>& y);

#endif /* TOOLBOX_H_ */
