/*
 * SPNFactory.h
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#ifndef SPNFACTORY_H_
#define SPNFACTORY_H_

#include <vector>
#include "SPN/SBox.h"
#include "SPN/Permutation.h"
#include "SPN/SPN.h"

using namespace std;

class SPNFactory {
public:
	SPNFactory();
	virtual ~SPNFactory();


	static vector<bool> simpleKeySchedule(const vector<bool>& key, ushort length);

	static vector<bool> stinsonKeySchedule(const vector<bool>& key);

	static Permutation stinsonPermutation();

	static SBox stinsonSBox();

	static SPN stinsonSPN();

};

#endif /* SPNFACTORY_H_ */
