/*
 * SPN.cpp
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#include <iostream>
#include <cassert>
#include <SPN/SPN.h>
#include <Utils/Toolbox.h>

using namespace std;

SPN::SPN() {
	id = "Undefined";
	description = "";
	nr_of_rounds = 0;
	bit_length = 0;
}

SPN::SPN(const SPN& spn) {
	id = spn.id;
	description = spn.description;
	nr_of_rounds = spn.nr_of_rounds;
	bit_length = spn.bit_length;
	sbox_array = spn.sbox_array;
	perm_array = spn.perm_array;
	inv_perm_array = spn.inv_perm_array;
	subkey_array = spn.subkey_array;
}

SPN::~SPN() {
}

void SPN::set(const string& id, const vector<SBoxArray>& sbox_array,
		const vector<Permutation>& perm_array) {

}

ushort SPN::getKeyLength() const {
	return (nr_of_rounds + 1) * bit_length;
}

void SPN::setKey(const vector<bool>& key) {
}

vector<bool> SPN::encrypt(const vector<bool>& block) const {
	vector<bool> result;

	return result;
}

vector<bool> SPN::decrypt(const vector<bool>& block) const {
	vector<bool> result;

	return result;
}

SBoxArray SPN::getFinalSBoxArray() const {
	assert(sbox_array.size()>0);
	return sbox_array.back();
}

ushort SPN::getBitLength() const {
	return bit_length;
}

ushort SPN::getSBoxBitLength() const {
	assert(sbox_array.size()>0);
	return sbox_array[0].getSBoxBitLength();
}

ushort SPN::getNrOfRounds() const {
	return nr_of_rounds;
}

vector<byte> SPN::encrypt(const vector<byte>& plain_text) const {
	vector<bool> result;

	return Toolbox::toByteArray(result);
}

vector<byte> SPN::decrypt(const vector<byte>& cipher_text) const {
	vector<bool> result;

	return Toolbox::toByteArray(result);
}

void SPN::setDescription(string d) {
	description = d;
}

string SPN::getDescription() const {
	return description;
}

SPN& SPN::operator=(const SPN& spn) {
	if (this != &spn) {
//		set(spn.id, spn.sbox_array, spn.perm_array);
//		setDescription(spn.description);
		id = spn.id;
		description = spn.description;
		nr_of_rounds = spn.nr_of_rounds;
		bit_length = spn.bit_length;
		sbox_array = spn.sbox_array;
		perm_array = spn.perm_array;
		inv_perm_array = spn.inv_perm_array;
		subkey_array = spn.subkey_array;
	}

	return *this;
}
