/*
 * SBoxArray.h
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#ifndef SBOXARRAY_H_
#define SBOXARRAY_H_

#include <vector>
#include <vector>
#include "SPN/SBox.h"

using namespace std;
class SBoxArray {
protected:
	/// Array containing the sboxes
	vector<SBox> sbox_array;
	/// Array containing the inverse sboxes
	vector<SBox> inv_sbox_array;
	/// Bit length of the sbox array
	ushort bit_length;
	/// Bit length of the sboxes in the array
	ushort sbox_bit_length;
public:
	SBoxArray();

	SBoxArray(const vector<SBox>& sbox_array);

	virtual ~SBoxArray();

	void set(const vector<SBox>& sbox_array);

	vector<bool> compute(const vector<bool>& block) const;

	vector<bool> invert(const vector<bool>& block) const;

	SBox getSBox(ushort i) const;

	ushort getBitLength() const;

	ushort getSBoxBitLength() const;

	ushort size() const;

};

#endif /* SBOXARRAY_H_ */
