/*
 * SBox.h
 *
 *      Author: Christoph Karg (Hochschule Aalen)
 */

#ifndef SBOX_H_
#define SBOX_H_

#include <iostream>
#include <vector>
#include <string>
#include "Defs/types.h"
#include "SPN/PermutationBase.h"

using namespace std;

class SBox : public PermutationBase {
protected:
	/// Bit length of both input and output
	ushort bit_length;


public:
	SBox();
	SBox(string id, ushort bit_length, vector<ushort> sbox);

	virtual ~SBox();

	void set(string id, ushort bit_length, vector<ushort> sbox);

	ostream& print(ostream& strm);

	SBox& operator=(const SBox& sbox);

	uint getSize() const;

	ushort getBitLength() const;

	SBox getInverse() const;
};

ostream& operator<<(ostream& strm, SBox s);

#endif /* SBOX_H_ */
