/*
 * SBox.cpp
 *
 *      Author: Christoph Karg (Hochschule Aalen)
 */

#include <cassert>
#include "SBox.h"

SBox::SBox() : PermutationBase() {
	this->id = "Demo S-Box";
	this->bit_length = 4;
	ushort A[] = { 14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7};
	vector<ushort> v(A,A+sizeof(A)/sizeof(ushort));
}

SBox::SBox(string id, ushort bit_length, vector<ushort> sbox) : PermutationBase(), bit_length(0) {
	this->set(id, bit_length, sbox);
}

SBox::~SBox() {}

ostream& SBox::print(ostream& strm) {
	strm << "   sbox id: " << id << endl;
	strm << "bit length: " << bit_length << endl;
	strm << "      size: " << pv.size() << endl;
	return strm;
}

void SBox::set(string id, ushort bit_length, vector<ushort> sbox) {
}

SBox& SBox::operator=(const SBox& sbox) {
	if (this!=&sbox) {
		this->id = sbox.id;
		this->bit_length = sbox.bit_length;
		this->pv = sbox.pv;
	}
	return *this;
}

uint SBox::getSize() const {
	return pv.size();
}

ushort SBox::getBitLength() const {
	return bit_length;
}

SBox SBox::getInverse() const {
}

ostream& operator<<(ostream& strm, SBox s) {
	return s.print(strm);
}


