/*
 * PermutationBase.h
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#ifndef PERMUTATIONBASE_H_
#define PERMUTATIONBASE_H_

#include <vector>
#include <string>
#include "Defs/types.h"

using namespace std;

class PermutationBase {
protected:
	string id;
	vector<ushort> pv;

	vector<ushort> invert() const;

public:
	PermutationBase();

	PermutationBase(string id, const vector<ushort>& pv);

	virtual ~PermutationBase();

	void set(const string& id, const vector<ushort> pv);

	ushort operator[](ushort i) const;

	string getId() const;

	int size() const;

};

#endif /* PERMUTATIONBASE_H_ */
