/*
 * Permutation.h
 *
 *      Author: Prof. Dr. Christoph Karg
 */

#ifndef PERMUTATION_H_
#define PERMUTATION_H_

#include <iostream>
#include "Defs/types.h"
#include "SPN/PermutationBase.h"

using namespace std;

class Permutation : public PermutationBase {
protected:
	/// Width for output
	int width;

public:
	Permutation();
	Permutation(string id, const vector<ushort>& pv);

	virtual ~Permutation();

	void set(const string& id, const vector<ushort> pv);

	ostream& print(ostream& strm);

	vector<bool> operator()(const vector<bool>& x) const;

	Permutation getInverse() const;

	ushort getBitLength() const;

};

ostream& operator<<(ostream& strm, Permutation p);

#endif /* PERMUTATION_H_ */
