/*
 * Permutation.cpp
 *
 *      Author: Prof. Dr. Christoph Karg
 */

#include <set>
#include <cassert>
#include "Defs/types.h"
#include "SPN/Permutation.h"
#include "Utils/Toolbox.h"

using namespace std;

Permutation::Permutation() {
	/// Width of values (only for output purposes)
	this->width=0;
}

Permutation::~Permutation() {
	// TODO Auto-generated destructor stub
}

Permutation::Permutation(string id, const vector<ushort>& pv) : PermutationBase() {
	set(id, pv);
}

void Permutation::set(const string& id, const vector<ushort> pv) {
	PermutationBase::set(id, pv);

	// Compute width (number of digits) for output purposes
	width=0;
	int i=pv.size()-1;
	while (i>0) {
		width++;
		i = i/10;
	}


}

ostream& Permutation::print(ostream& strm) {
	strm << id << "/" << Toolbox::toString(pv, width);
	return strm;
}

ostream& operator <<(ostream& strm, Permutation p) {
	return p.print(strm);
}

vector<bool> Permutation::operator ()(const vector<bool>& x) const {
}

Permutation Permutation::getInverse() const {
}

ushort Permutation::getBitLength() const {
	return pv.size();
}

