# - Find READLINE
# This module looks for Readline library support
# it will define the following values
#  READLINE_INCLUDE_DIR  = directory containing cryptlib.h
#  READLINE_LINK_DIR	 = directory containing libREADLINE.so
#  READLINE_LIBRARY   	 = Crypto++ library
#  READLINE_FOUND        = true -> all files were found
#
# Usage: FIND_PACKAGE(READLINE, REQUIRED)
# 
# Assume that everything is ok
SET(READLINE_FOUND "YES")

#
# readline.h
#
FIND_PATH(READLINE_INCLUDE_DIR 
  readline.h 
  PATHS /usr/local/include/* /usr/include/*
)

IF (NOT READLINE_INCLUDE_DIR)
  SET(READLINE_FOUND "NO")
  IF (READLINE_FIND_REQUIRED) 
    MESSAGE(FATAL_ERROR  "Could not find readline.h")
  ENDIF (READLINE_FIND_REQUIRED) 
ENDIF (NOT READLINE_INCLUDE_DIR)

#
#  library
#
FIND_LIBRARY(READLINE_LIBRARY
  NAMES readline
  PATHS /usr/local/lib /usr/lib
) 

IF (NOT READLINE_LIBRARY)
  SET(READLINE_FOUND "NO")
  IF (READLINE_FIND_REQUIRED) 
    MESSAGE(FATAL_ERROR  "Could not find readline library")
  ENDIF (READLINE_FIND_REQUIRED) 
ENDIF (NOT READLINE_LIBRARY)

GET_FILENAME_COMPONENT(READLINE_LINK_DIR ${READLINE_LIBRARY} PATH )

#
# Checking ...
#
IF (READLINE_FOUND)
  IF (NOT READLINE_FIND_QUIETLY)
    MESSAGE(STATUS "Found readline.h in..: ${READLINE_INCLUDE_DIR}")
    MESSAGE(STATUS "Found readline lib...: ${READLINE_LIBRARY}")
#    MESSAGE(STATUS "Library link dir.....: ${READLINE_LINK_DIR}")
  ENDIF (NOT READLINE_FIND_QUIETLY)
ELSE (READLINE_FOUND)
  IF (NOT READLINE_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR  "Could not find readline library")
  ENDIF (NOT READLINE_FIND_QUIETLY)
ENDIF (READLINE_FOUND)


MARK_AS_ADVANCED(
  READLINE_INCLUDE_DIR
  READLINE_LIBRARY
)
