/*
 * stinsonspn.cpp
 *
 *      Author: Prof. Dr. Christoph Karg (Hochschule Aalen)
 */

#include <iostream>
#include <iomanip>
#include <ctime>
#include <random>
#include "SPN/SPNFactory.h"
#include "Utils/Toolbox.h"

using namespace std;

int main() {

	cout << "Stinson SPN:" << endl;
	cout << "============" << endl << endl;

	vector<bool> key = Toolbox::toBitVector("0110 1100 0101 0110 1100");
	SPN spn = SPNFactory::stinsonSPN();
	spn.setKey(SPNFactory::simpleKeySchedule(key, spn.getKeyLength()));

	vector<byte> pt, ct;
	pt = Toolbox::toByteArray("Dies ist ein Test!!!!!");
	ct = spn.encrypt(pt);

	cout << "pt: " << Toolbox::toString(pt) << endl;
	cout << "ct: " << Toolbox::toHexString(ct) << endl;

	pt = spn.decrypt(ct);
	cout << "pt: " << Toolbox::toString(pt) << endl;


	return 0;
}
