#! /usr/bin/env python

# ******************************************************************************
# * A simple IP sniffer for Scapy
# *
# * Christoph Karg (1.6.2016)
# ******************************************************************************

# Import all stuff from the scapy API
from scapy.all import *

# A simple packet dump.
def dump(pkt):
	return pkt.summary()

# A function to dump address information of IP packets
# (with MAC address information and ports)
def ip_dump(pkt):
	s = ""
	if IP in pkt:
		if TCP in pkt:
			s = pkt.sprintf("%IP.proto%: ")
			s += pkt.sprintf("%IP.src% (%Ether.src%) %TCP.sport%")
			s += " => "
			s += pkt.sprintf("%IP.dst% (%Ether.dst%) %TCP.dport%")
		elif UDP in pkt:
			s = pkt.sprintf("%IP.proto%: ")
			s += pkt.sprintf("%IP.src% (%Ether.src%) %UDP.sport%")
			s += " => "
			s += pkt.sprintf("%IP.dst% (%Ether.dst%) %UDP.dport%")
		else:
			s = pkt.sprintf("%IP.proto%: ")
			s += pkt.sprintf("%IP.src% (%Ether.src%)")
			s += " => "
			s += pkt.sprintf("%IP.dst% (%Ether.dst%)")
	return s

# Version 1
#sniff(iface="wlp4s0", filter="ip", prn=dump, store=0)

# Version 2
sniff(iface="vboxnet0", filter="ip", prn=ip_dump, store=0)

