#! /usr/bin/env python

# ******************************************************************************
# * ARP monitoring with Scapy
# *
# * Christoph Karg (1.6.2016)
# ******************************************************************************

# Import all stuff from the scapy API
from scapy.all import *

#
# Scapy prn function for ARP packets
#
# Parameters:
# - pkt : captured Scapy packet
#
def arp_monitor(pkt):
    if ARP in pkt:
		apkt = pkt[ARP]
		# who-has package
		if apkt.op==1:
			s = apkt.sprintf("ARP: %ARP.hwsrc% (%ARP.psrc%) ") \
			+ apkt.sprintf("asks: %ARP.op% %ARP.pdst%?")
			
		#is-at package
		if apkt.op==2:
			s = apkt.sprintf("ARP: Answer for %ARP.hwdst% (%ARP.pdst%): ") \
			+ apkt.sprintf("%ARP.psrc% %ARP.op% %ARP.hwsrc%.")

		return s

#
# Main
#
sniff(prn=arp_monitor, store=0, iface="wlp4s0")
#sniff(prn=arp_monitor, store=0, iface="vboxnet0")

